/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.base.settings.user.UserSettingsBean;
import com.ibm.hwmca.fw.settings.user.ObjectControlsSettings;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.UserTaskManager;

public class ObjectControlsBean
extends UserSettingsBean {
    private ObjectControlsSettings settings;
    private ObjectControlsSettings savedSettings;
    private static final String TRACE_MASKT = "HUSOCB T";
    private static final String TRACE_MASKF = "HUSOCB F";
    private static final String TRACE_MASKD = "HUSOCB D";
    private static final String SHOW_HOVER_HELP_ELEMENT = "ShowHoverHelpToggle";
    private static final String SINGLE_SELECTION_ELEMENT = "SingleObjectSelectionToggle";
    private boolean showHoverHelpToggle;
    private boolean singleObjectSelectionToggle;

    public void setUserSettings(ObjectControlsSettings settings) {
        Trace.trace(TRACE_MASKF, "-> ObjectControlsBean.setUserSettings()");
        Trace.trace(TRACE_MASKF, settings);
        this.settings = settings;
        Trace.trace(TRACE_MASKF, "<- ObjectControlsBean.setUserSettings()");
    }

    public void setShowHoverHelpToggle(boolean b) throws IllegalUserDataException {
        this.showHoverHelpToggle = b;
        this.settings.setShowHoverHelp(b);
    }

    public boolean isShowHoverHelpToggle() {
        return this.showHoverHelpToggle;
    }

    public void setSingleObjectSelectionToggle(boolean b) throws IllegalUserDataException {
        this.singleObjectSelectionToggle = b;
        this.settings.setSingleSelection(b);
    }

    public boolean isSingleObjectSelectionToggle() {
        return this.singleObjectSelectionToggle;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.showHoverHelpToggle = false;
        this.singleObjectSelectionToggle = false;
    }

    public void save() {
    }

    public void update(Object object) {
        Trace.trace(TRACE_MASKF, "-> ObjectControlsBean.update()");
        this.setUserSettings((ObjectControlsSettings)object);
        this.initSettingsData();
        this.refreshPanel(this.getUserTaskManager());
        Trace.trace(TRACE_MASKF, "<- ObjectControlsBean.update()");
    }

    private void initSettingsData() {
        this.showHoverHelpToggle = this.settings.isShowHoverHelp();
        this.singleObjectSelectionToggle = this.settings.isSingleSelection();
    }

    protected boolean hasSettingsChanged() {
        Trace.trace(TRACE_MASKF, "-> ObjectControlsBean.hasSettingsChanged()");
        UserTaskManager utm = this.getUserTaskManager();
        utm.storeAllElements();
        boolean result = !this.settings.equals(this.savedSettings);
        Trace.trace(TRACE_MASKF, "<- ObjectControlsBean.hasSettingsChanged(), result is " + result);
        return result;
    }

    protected void refreshPanel(UserTaskManager utm) {
        String prefix = this.getMountPrefix();
        utm.refreshElement(prefix + SHOW_HOVER_HELP_ELEMENT);
        utm.refreshElement(prefix + SINGLE_SELECTION_ELEMENT);
    }

    protected void updateUserSettings() {
        Trace.trace(TRACE_MASKF, "<> ObjectControlsBean.updateUserSettings()");
        this.savedSettings = (ObjectControlsSettings)this.settings.clone();
    }

    protected void resetUserSettings(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "<> ObjectControlsBean.resetUserSettings()");
        this.settings = (ObjectControlsSettings)this.savedSettings.clone();
        this.initSettingsData();
        this.refreshPanel(utm);
    }

    protected UserSettings getUserSettings() {
        Trace.trace(TRACE_MASKF, "<> ObjectControlsBean.getUserSettings()");
        return this.settings;
    }

    public void prepare() {
        this.savedSettings = (ObjectControlsSettings)this.settings.clone();
        this.initSettingsData();
    }
}

